/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.domsec;

import com.ibm.hwmca.base.domsec.DomainSecurityBean;
import com.ibm.hwmca.base.domsec.DomainSecurityIds;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.base.util.SimServer;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.domsec.DomainSecurity;
import com.ibm.hwmca.fw.domsec.DomainSecurityException;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.log.E4EventLog;
import com.ibm.hwmca.fw.log.FrameworkEventText;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.HwmcaObject;
import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.Tower;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DomainSecurityTasklet
extends PanelTasklet
implements DomainSecurityIds {
    private static final String TRACE_MASKT = "HACADSTT";
    private static final String TRACE_MASKF = "HACADSTF";
    private static final String TRACE_MASKD = "HACADSTD";
    private static final byte[] HACA_HMC_DOMAIN = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] HACA_SE_DOMAIN = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
    private static final byte[] HACA_LU_PASSWORD = new byte[]{80, 65, 83, 83, 22, 22, 22, 22, 0};
    private static final String LOG_EVENT_NAME = "DOMPWCHG";
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.base.domsec.res.DomainSecurityRes";
    private static final String PANEL_NAME = "DomainSecurityPanel";
    private static final String ROLE_GROUP_PEDEBUG = "base.rolegroup.pedebug";
    private static final String ROLE_GROUP_SERVICE = "base.rolegroup.service";
    private List implList = null;
    private String domain = "";
    private String password = "";
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$Tower;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$ManagedObject;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$domsec$DomainSecurity;

    public DomainSecurityTasklet() {
        Trace.trace(TRACE_MASKT, "<> DomainSecurityTasklet.DomainSecurityTasklet()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> DomainSecurityTasklet.logException(" + throwable + ")");
        Trace.trace(TRACE_MASKF, throwable);
        new FrameworkLog(DomainSecurityIds.logInfo, 4097, throwable).log();
        Trace.trace(TRACE_MASKT, "<- DomainSecurityTasklet.logException()");
    }

    public void service(PanelTaskletRequest panelTaskletRequest, PanelTaskletResponse panelTaskletResponse) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> DomainSecurityTasklet.service(" + panelTaskletRequest + ", " + panelTaskletResponse + ")");
        if (panelTaskletRequest.isInitialRequest()) {
            Trace.trace(TRACE_MASKF, "DomainSecurityTasklet.service(): panelTaskletRequest.isInitialRequest(), displaying the panel.");
            try {
                DomainSecurityBean bean = new DomainSecurityBean();
                bean.setBeanName("DomainSecurityBean");
                SimServer simServer = SimServer.getSimServer();
                byte[] b = simServer.readSim(18);
                String currentDomain = new String(b);
                if (b[0] == 0) {
                    bean.setCurrentDomainNameOutput("NOT SET");
                } else {
                    int i = currentDomain.indexOf(0);
                    bean.setCurrentDomainNameOutput(currentDomain.substring(0, i));
                }
                byte[] consoleType = simServer.readSim(5);
                switch (consoleType[0]) {
                    case 1: 
                    case 3: {
                        bean.setSE(true);
                        break;
                    }
                    case 4: {
                        bean.setPHMC(true);
                        break;
                    }
                    default: {
                        bean.setSE(false);
                        bean.setPHMC(false);
                    }
                }
                if (User.getUser().hasAuth(ROLE_GROUP_PEDEBUG) || User.getUser().hasAuth(ROLE_GROUP_SERVICE)) {
                    bean.setResetDefaultsShown(true);
                } else {
                    bean.setResetDefaultsShown(false);
                }
                panelTaskletResponse.replace(AUIML_FILE_NAME, PANEL_NAME, bean);
            }
            catch (Exception exc) {
                throw new TaskletException(exc);
            }
        }
        if (panelTaskletRequest.isDisposed() || panelTaskletRequest.isCanceled()) {
            Trace.trace(TRACE_MASKF, "DomainSecurityTasklet.service(): panelTaskletRequest.isDisposed() or isCanceled, issue panelTaskletResponse.terminate.");
            panelTaskletResponse.terminate();
        } else {
            Trace.trace(TRACE_MASKD, "DomainSecurityTasklet.service(): panelTaskletRequest.getData(): " + panelTaskletRequest.getData("event") + ".");
            String event = (String)panelTaskletRequest.getData("event");
            this.domain = (String)panelTaskletRequest.getData("domain");
            this.password = (String)panelTaskletRequest.getData("password");
            if (event.equals("CANCEL")) {
                Trace.trace(TRACE_MASKF, "DomainSecurityTasklet.service(): Cancel request, end panel.");
                panelTaskletResponse.terminate();
            } else if (event.equals("ApplyHMCItem")) {
                this.verifyData();
                if (this.setConsoleDomain(this.domain.getBytes(), this.password.getBytes())) {
                    FrameworkEventText fet = new FrameworkEventText(787);
                    new SystemEventLog(fet, LOG_EVENT_NAME).log();
                    new E4EventLog(fet, LOG_EVENT_NAME).log();
                    this.showMessageBox(true, new BaseMessageTitle("HACA800K"), new BaseMessageText("HACA000K"), null, null);
                    panelTaskletResponse.update(this.domain);
                } else {
                    this.showMessageBox(true, new BaseMessageTitle("HACA8008"), new BaseMessageText("HACA0008"), null, null);
                    panelTaskletResponse.noAction();
                }
            } else if (event.equals("ResetMfgDefaultItem")) {
                try {
                    byte[] bHmcType = SimServer.getSimServer().readSim(5);
                    switch (bHmcType[0]) {
                        case 1: 
                        case 3: {
                            this.domain = new String(HACA_SE_DOMAIN);
                            break;
                        }
                        default: {
                            this.domain = new String(HACA_HMC_DOMAIN);
                            break;
                        }
                    }
                }
                catch (HException hexc) {
                    Trace.trace(TRACE_MASKF, "DomainSecurityTasklet.service(): Exception reading XCPC_STATUS SIM field");
                    Trace.trace(TRACE_MASKF, hexc);
                    this.domain = new String(HACA_HMC_DOMAIN);
                }
                this.password = new String(HACA_LU_PASSWORD);
                if (this.setConsoleDomain(this.domain.getBytes(), this.password.getBytes())) {
                    FrameworkEventText fet = new FrameworkEventText(787);
                    new SystemEventLog(fet, LOG_EVENT_NAME).log();
                    new E4EventLog(fet, LOG_EVENT_NAME).log();
                    this.showMessageBox(true, new BaseMessageTitle("HACA800K"), new BaseMessageText("HACA000K"), null, null);
                    panelTaskletResponse.update(this.domain);
                } else {
                    this.showMessageBox(true, new BaseMessageTitle("HACA8008"), new BaseMessageText("HACA0008"), null, null);
                    panelTaskletResponse.noAction();
                }
            } else {
                this.verifyData();
                if (event.equals("ApplyDefinedObjectsItem")) {
                    String errorMessage = this.setAll(this.domain.getBytes(), this.password.getBytes());
                    if (errorMessage == null) {
                        if (this.setConsoleDomain(this.domain.getBytes(), this.password.getBytes())) {
                            FrameworkEventText fet = new FrameworkEventText(787);
                            new SystemEventLog(fet, LOG_EVENT_NAME).log();
                            new E4EventLog(fet, LOG_EVENT_NAME).log();
                            this.showMessageBox(true, new BaseMessageTitle("HACA800K"), new BaseMessageText("HACA000K"), null, null);
                            panelTaskletResponse.update(this.domain);
                        } else {
                            this.showMessageBox(true, new BaseMessageTitle("HACA8008"), new BaseMessageText("HACA0008"), null, null);
                            panelTaskletResponse.noAction();
                        }
                    } else {
                        this.showMessageBox(true, new BaseMessageTitle("HACA8008"), new BaseMessageText("HACA000B", new String[]{errorMessage}), null, null);
                        panelTaskletResponse.noAction();
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "DomainSecurityTasklet.service(): Unknown request sent to the DomainSecurityTasklet.");
                    panelTaskletResponse.terminate();
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- DomainSecurityTasklet.service()");
    }

    private String setAll(byte[] name, byte[] pw) {
        Trace.trace(TRACE_MASKF, "-> DomainSecurityTasklet.setAll()");
        String s = null;
        this.implList = this.findUsers();
        Iterator iterator = this.implList.iterator();
        while (iterator.hasNext()) {
            DomainSecurity implClass = (DomainSecurity)iterator.next();
            try {
                implClass.getReady(name, pw);
                implClass.alter();
            }
            catch (DomainSecurityException exc) {
                Trace.trace(TRACE_MASKF, exc);
                implClass.abort();
                s = exc.getMessage().substring(0, exc.getMessage().indexOf(" ") + 1);
            }
        }
        Trace.trace(TRACE_MASKT, "<- DomainSecurityTasklet.setAll().");
        return s;
    }

    private boolean setConsoleDomain(byte[] name, byte[] pw) {
        Trace.trace(TRACE_MASKF, "-> DomainSecurityTasklet.setConsoleDomain()");
        boolean result = true;
        try {
            SimServer.getSimServer().writeSim(18, name);
            SimServer.getSimServer().writeSim(17, pw);
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
            result = false;
        }
        if (this.implList == null) {
            this.implList = this.findUsers();
        }
        Iterator iterator = this.implList.iterator();
        while (iterator.hasNext()) {
            DomainSecurity implClass = (DomainSecurity)iterator.next();
            implClass.nameHasChanged();
        }
        if (result) {
            int i;
            for (i = 0; i < name.length && name[i] != 0; ++i) {
            }
            String group = new String(name, 0, i);
            FcsServer fcsServer = FcsServer.getFcsServer();
            if (fcsServer != null) {
                fcsServer.domainNameChanged(group);
            }
        }
        Trace.trace(TRACE_MASKT, "<- DomainSecurityTasklet.setConsoleDomain(): returns " + result);
        return result;
    }

    private void verifyData() {
        byte[] b;
        Trace.trace(TRACE_MASKT, "-> DomainSecurityTasklet.verifyData()");
        if (this.domain == null || this.domain.length() == 0) {
            try {
                b = SimServer.getSimServer().readSim(18);
                this.domain = new String(b);
            }
            catch (Exception exc) {
                Trace.trace(TRACE_MASKF, exc);
            }
        }
        if (this.password == null || this.password.length() == 0) {
            try {
                b = SimServer.getSimServer().readSim(17);
                this.password = new String(b);
            }
            catch (Exception exc) {
                Trace.trace(TRACE_MASKF, exc);
            }
        }
        Trace.trace(TRACE_MASKT, "<- DomainSecurityTasklet.verifyData()");
    }

    private List findUsers() {
        Trace.trace(TRACE_MASKF, "-> DomainSecurityTasklet.findUsers()");
        Object impl = null;
        ClassId[] ids = new ClassId[]{new ClassId(class$com$ibm$hwmca$fw$managed$Tower == null ? (class$com$ibm$hwmca$fw$managed$Tower = DomainSecurityTasklet.class$("com.ibm.hwmca.fw.managed.Tower")) : class$com$ibm$hwmca$fw$managed$Tower), new ClassId(class$com$ibm$hwmca$fw$managed$ManagedObject == null ? (class$com$ibm$hwmca$fw$managed$ManagedObject = DomainSecurityTasklet.class$("com.ibm.hwmca.fw.managed.ManagedObject")) : class$com$ibm$hwmca$fw$managed$ManagedObject)};
        this.implList = new ArrayList();
        Set inventory = ManagedObjectManager.getManagedObjectManager().getInventory(ids);
        Iterator iterator = inventory.iterator();
        while (iterator.hasNext()) {
            HwmcaObject obj = (HwmcaObject)iterator.next();
            if (obj instanceof Tower) {
                Trace.trace(TRACE_MASKD, "DomainSecurityTasklet.findUsers(): Tower found = " + ((Tower)obj).getName() + ".");
                impl = ((Tower)obj).getInterfaceImpl(class$com$ibm$hwmca$fw$domsec$DomainSecurity == null ? DomainSecurityTasklet.class$("com.ibm.hwmca.fw.domsec.DomainSecurity") : class$com$ibm$hwmca$fw$domsec$DomainSecurity);
            } else if (obj instanceof ManagedObject) {
                Trace.trace(TRACE_MASKD, "DomainSecurityTasklet.findUsers(): ManagedObject found = " + ((ManagedObject)obj).getName() + ".");
                impl = ((ManagedObject)obj).getInterfaceImpl(class$com$ibm$hwmca$fw$domsec$DomainSecurity == null ? DomainSecurityTasklet.class$("com.ibm.hwmca.fw.domsec.DomainSecurity") : class$com$ibm$hwmca$fw$domsec$DomainSecurity);
            }
            if (impl == null) continue;
            Trace.trace(TRACE_MASKD, "DomainSecurityTasklet.findUsers(): Add to list.");
            this.implList.add(impl);
            impl = null;
        }
        Trace.trace(TRACE_MASKT, "<- DomainSecurityTasklet.findUsers()");
        return this.implList;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

